package coreservlets;

import javax.servlet.http.*;
import org.apache.struts.action.*;

/** Obiekt Action, ktry otrzymuje dane wejciowe wpisane
 *  przez uytkownika z komponentu bean formularza.
 *  Jeeli w danych wejciowych jest bd, w komponencie
 *  bean zapisany zostanie odpowiedni komunikat.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class SignupAction1 extends Action {
  public ActionForward execute(ActionMapping mapping,
                               ActionForm form,
                               HttpServletRequest request,
                               HttpServletResponse response)
      throws Exception {
    ContactFormBean userBean = (ContactFormBean)form;
    String firstName = userBean.getFirstName();
    String lastName = userBean.getLastName();
    String email = userBean.getEmail();
    String faxNumber = userBean.getFaxNumber();
    if (userBean.isMissing(firstName)) {
      makeWarning(request, "imi");
      return(mapping.findForward("missing-value"));
    } else if (userBean.isMissing(lastName)) {
      makeWarning(request, "nazwisko");
      return(mapping.findForward("missing-value"));
    } else if ((userBean.isMissing(email)) ||
               (email.indexOf("@") == -1)) {
      makeWarning(request, "adres email");
      return(mapping.findForward("missing-value"));
    } else if (userBean.isMissing(faxNumber)) {
      makeWarning(request, "numer faksu");
      return(mapping.findForward("missing-value"));
    } else {
      return(mapping.findForward("success"));
    }
  }

  protected void makeWarning(HttpServletRequest request,
                             String message) {
    MessageBean messageBean = new MessageBean();
    messageBean.setMessage(message);
    request.setAttribute("messageBean", messageBean);
  }
}
